(****************************************************************************)
(* Module name: SendKeys.C                                                  *)
(* Programmer : Jeffrey M. Richter.                                         *)
(* Description: Simulation of the VB/Word/Excel SendKeys statement.         *)
(****************************************************************************)
unit Sendkey;

interface

uses
  SysUtils, WinTypes, WinProcs;


type
  TSendKeysErr = (SK_NOERROR, SK_MISSINGCLOSEBRACE, SK_INVALIDKEY,
                  SK_MISSINGCLOSEPAREN, SK_INVALIDCOUNT, SK_STRINGTOOLONG,
                  SK_CANTINSTALLHOOK);


function SendKeys(szKeys : PChar) : TSendKeysErr;

function SendKeysStr(Keys : String) : TSendKeysErr;

function VMSendKeys(szKeys : PChar) : TSendKeysErr;

procedure PostVirtualKeyEvent(bVirtKey : Byte; fUp : Boolean);


(***************************************************************************************)
implementation


function SendKeysStr(Keys : String) : TSendKeysErr;
var s : array[0..255] of Char;
begin
  StrPCopy(s, Keys);
  SendKeys(s);
end;

function SendKeys(szKeys : PChar) : TSendKeysErr; external 'SENDKEYS';

function VMSendKeys(szKeys : PChar) : TSendKeysErr; external 'SENDKEYS';

procedure PostVirtualKeyEvent(bVirtKey : Byte; fUp : Boolean); external 'SENDKEYS';




end.
